<?php

namespace oms\contentparser;

use Symfony\Component\Yaml\Yaml;

class Parser
{
    private $assetsDir;
    private $imageUrl;
    private $data = [];

    public function __construct($assetsDir)
    {
        if (!is_dir($assetsDir)) {
            throw new \Exception("Directory '{$assetsDir}' with Assets does not exists.");
        }
        $this->assetsDir = $assetsDir;
    }

    private function getData($templatePath)
    {
        if (file_exists($templatePath)) {
            $this->data = Yaml::parse(file_get_contents($templatePath));
            return $this->data;
        } else {
            throw new \Exception("Template '{$templatePath}' does not exists.");
        }
    }

    public function setImageSrc($imageSrc)
    {
        $this->imageUrl = $imageSrc;
    }

    public function getImageSrc()
    {
        return $this->imageUrl;
    }

    public function getTemplate($templatePath)
    {
        return [
            'title' => $this->getTitle($templatePath),
            'body' => $this->getBody($templatePath),
            'slug' => $this->getSlug($templatePath),
            'linkText' => $this->getLinkText($templatePath),
            'order' => $this->getOrder($templatePath),
            'pdf' => $this->getPdf($templatePath),
            'organization' => $this->getOrganization($templatePath),
            'question' => $this->getQuestion($templatePath),
            'field' => $this->getQuestion($templatePath),
            'fieldType' => $this->getQuestion($templatePath),
        ];
    }

    public function getTitle($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['title'])) ? $data['title'] : NULL;
    }

    public function getBody($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        $content = NULL;
        if (isset($data['content_parts'])) {
            foreach ($data['content_parts'] as $part) {
                if ($part['type'] === 'text') {
                    $content .= $part['body'];
                }
                if ($part['type'] === 'image') {
                    $file = $this->assetsDir . DIRECTORY_SEPARATOR . $part['filename'];
                    if (file_exists($file)) {
                        $src = $this->imageUrl . '/' . $part['filename'];
                        $content .= '<img title="' . $part['title'] . '" alt="' . $part['alt'] . '" src="' . $src . '">';
                    }
                }
            }
        }
        return $content;
    }

    public function getSlug($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['slug'])) ? $data['slug'] : NULL;
    }

    public function getLinkText($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['link_text'])) ? $data['link_text'] : NULL;
    }

    public function getOrder($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['order'])) ? $data['order'] : NULL;
    }

    public function getPdf($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['pdf'])) ? $data['pdf'] : NULL;
    }

    public function getOrganization($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['organization'])) ? $data['organization'] : NULL;
    }

    public function getQuestion($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['question'])) ? $data['question'] : NULL;
    }

    public function getField($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['field'])) ? $data['field'] : NULL;
    }

    public function getFieldType($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['fieldType'])) ? $data['fieldType'] : NULL;
    }
}