<?php

namespace oms\contentparser;

use Symfony\Component\Yaml\Yaml;

class Parser
{
    private $assetsDir;
    private $imageUrl;
    private $data = [];

    public function __construct($assetsDir)
    {
        if (!is_dir($assetsDir)) {
            throw new \Exception("Directory '{$assetsDir}' with Assets does not exists.");
        }
        $this->assetsDir = $assetsDir;
    }

    private function getData($templatePath)
    {
        if (file_exists($templatePath)) {
            $this->data = Yaml::parse(file_get_contents($templatePath));
            return $this->data;
        } else {
            throw new \Exception("Template '{$templatePath}' does not exists.");
        }
    }

    public function setImageSrc($imageSrc)
    {
        $this->imageUrl = $imageSrc;
    }

    public function getImageSrc()
    {
        return $this->imageUrl;
    }

    public function getTemplate($templatePath)
    {
        return [
            'title' => $this->getTitle($templatePath),
            'body' => $this->getBody($templatePath),
            'slug' => $this->getSlug($templatePath),
            'linkText' => $this->getLinkText($templatePath)
        ];
    }

    public function getTitle($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['title'])) ? $data['title'] : NULL;
    }

    public function getBody($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        $content = NULL;
        if (isset($data['content_parts'])) {
            foreach ($data['content_parts'] as $part) {
                if ($part['type'] === 'text') {
                    $content .= $part['body'];
                }
                if ($part['type'] === 'image') {
                    $file = $this->assetsDir . DIRECTORY_SEPARATOR . $part['filename'];
                    if (file_exists($file)) {
                        $src = $this->imageUrl . '/' . $part['filename'];
                        $content .= '<img title="' . $part['title'] . '" alt="' . $part['alt'] . '" src="' . $src . '">';
                    }
                }
            }
        }
        return $content;
    }

    public function getSlug($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['slug'])) ? $data['slug'] : NULL;
    }

    public function getLinkText($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['link_text'])) ? $data['link_text'] : NULL;
    }
}