<?php

namespace oms\contentparser;

class ContentClient
{
    public $mediaDir;
    public $imageUrl;

    private $title;
    private $body;
    private $slug;
    private $linkText;

    private $parser;

    private function createParser()
    {
        $this->parser = new Parser($this->mediaDir . DIRECTORY_SEPARATOR . 'assets');
        $this->parser->setImageSrc($this->imageUrl);
    }

    public function getTemplate($templatePath)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        return $this->parser->getTemplate($templatePath);
    }

    public function getAllTemplates($dirPath)
    {
        if (!is_dir($dirPath)) {
            throw new \Exception("Directory '{$dirPath}' with Meta does not exists.");
        }
        $result = [];
        foreach (new \DirectoryIterator($dirPath) as $file) {
            if ($file->isFile() && $file->getExtension() === 'md') {
                $templatePath = $dirPath . DIRECTORY_SEPARATOR . $file->getFilename();
                $result[] = $this->getTemplate($templatePath);
            }
        }
        return $result;
    }

    public function getTitle($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->title = $this->parser->getTitle($template);
        return $this->title;
    }

    public function getBody($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->body = $this->parser->getBody($template);
        return $this->body;
    }

    public function getSlug($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->slug = $this->parser->getSlug($template);
        return $this->slug;
    }

    public function getLinkText($template)
    {
        if (!$this->parser) {
            $this->createParser();
        }
        $this->linkText = $this->parser->getLinkText($template);
        return $this->linkText;
    }

    public function setTitle($title)
    {
        $this->title = $title;
    }

    public function setBody($body)
    {
        $this->body = $body;
    }

    public function setSlug($slug)
    {
        $this->slug = $slug;
    }

    public function setLinkText($linkText)
    {
        $this->linkText = $linkText;
    }
}