<?php

namespace oms\contentparser;

use Symfony\Component\Yaml\Yaml;

class Parser
{
    private $assetsDir;
    private $pagesDir;
    private $imageUrl;
    private $data = [];

    public function __construct($assetsDir, $pagesDir)
    {
        if (!is_dir($assetsDir)) {
            throw new \Exception("Directory '{$assetsDir}' with Assets does not exists.");
        }
        if (!is_dir($pagesDir)) {
            throw new \Exception("Directory '{$pagesDir}' with Pages does not exists.");
        }
        $this->assetsDir = $assetsDir;
        $this->pagesDir = $pagesDir;
    }

    private function getData($template)
    {
        $file = $this->pagesDir . DIRECTORY_SEPARATOR . $template;
        if (file_exists($file)) {
            $this->data = Yaml::parse(file_get_contents($file));
            return $this->data;
        } else {
            throw new \Exception("Template '{$file}' does not exists.");
        }
    }

    public function setImageSrc($imageSrc)
    {
        $this->imageUrl = $imageSrc;
    }

    public function getImageSrc()
    {
        return $this->imageUrl;
    }

    public function getPage($template)
    {
        return [
            'title' => $this->getTitle($template),
            'body' => $this->getBody($template),
            'slug' => $this->getSlug($template),
            'linkText' => $this->getLinkText($template)
        ];
    }

    public function getTitle($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['title'])) ? $data['title'] : NULL;
    }

    public function getBody($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        $content = NULL;
        if (isset($data['content_parts'])) {
            foreach ($data['content_parts'] as $part) {
                if ($part['type'] === 'text') {
                    $content .= $part['body'];
                }
                if ($part['type'] === 'image') {
                    $file = $this->assetsDir . DIRECTORY_SEPARATOR . $part['filename'];
                    if (file_exists($file)) {
                        $src = $this->imageUrl . '/' . $part['filename'];
                        $content .= '<img title="' . $part['title'] . '" alt="' . $part['alt'] . '" src="' . $src . '">';
                    }
                }
            }
        }
        return $content;
    }

    public function getSlug($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['slug'])) ? $data['slug'] : NULL;
    }

    public function getLinkText($template = NULL)
    {
        $data = ($template || empty($this->data)) ? $this->getData($template) : $this->data;
        return (isset($data['link_text'])) ? $data['link_text'] : NULL;
    }
}