<?php
namespace blankon\widgets;

use Yii;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\Menu;

class BlankonMenu extends Menu
{
    public $options = ['class' => 'sidebar-menu', 'style' => 'overflow: hidden; outline: none;'];
//    public $itemOptions;
    public $optionsAside = ['id' => 'sidebar-left', 'class' => 'sidebar-circle'];
    public $activeCssClass = 'active';
    public $submenuTemplate = "\n<ul>\n{items}\n</ul>\n";
    public $labelTemplate = '{label}';
    public $linkTemplate = '
            <a href="{url}">
                <span class="icon"><i class="{icon}"></i></span>
                <span class="text">{label}</span>
            </a>';
    public $linkSubMenuTemplate = '
            <a href="javascript:void(0);">
                <span class="icon"><i class="{icon}"></i></span>
                <span class="text">{label}</span>
                <span class="arrow"></span>
            </a>';


    public $categoryTemplate = '
            <span>{category}</span>
            <span class="pull-right"><i class="fa fa-code"></i></span>
           ';

    public $linkSubItemTemplate = '<a href="{url}">{label}</a>';

    public function run()
    {
        if ($this->route === null && Yii::$app->controller !== null) {
            $this->route = Yii::$app->controller->getRoute();
        }
        if ($this->params === null) {
            $this->params = Yii::$app->request->getQueryParams();
        }
        $items = $this->normalizeItems($this->items, $hasActiveChild);
        if (!empty($items)) {
            $optionsAside = $this->optionsAside;
            $aside = ArrayHelper::remove($optionsAside, 'tag', 'aside');
            $options = $this->options;
            $tag = ArrayHelper::remove($options, 'tag', 'ul');

            echo Html::tag($aside, Html::tag($tag, $this->createItems($items), $options), $optionsAside);
        }
    }

    protected function createItems($items, $subMenu = false)
    {
        $n = count($items);
        $lines = [];
        foreach ($items as $i => $item) {
            $options = array_merge($this->itemOptions, ArrayHelper::getValue($item, 'options', []));
            $tag = ArrayHelper::remove($options, 'tag', 'li');
            $class = [];
            if ($item['active']) {
                $class[] = $this->activeCssClass;
            }
            if ($i === 0 && $this->firstItemCssClass !== null) {
                $class[] = $this->firstItemCssClass;
            }
            if ($i === $n - 1 && $this->lastItemCssClass !== null) {
                $class[] = $this->lastItemCssClass;
            }
            if (!empty($item['items'])) {
                //find active submenu link
                if (array_search(true, array_column($item['items'], 'active')) !== false) {
                    $class[] = 'submenu active';
                } else {
                    $class[] = 'submenu';
                }
            }
            if (!empty($item['category'])) {
                $class[] = 'sidebar-category';
            }

            if (!empty($class)) {
                if (empty($options['class'])) {
                    $options['class'] = implode(' ', $class);
                } else {
                    $options['class'] .= ' ' . implode(' ', $class);
                }
            }

            $menu = $this->createItem($item, $subMenu);
            if (!empty($item['items'])) {
                $submenuTemplate = ArrayHelper::getValue($item, 'submenuTemplate', $this->submenuTemplate);
                $menu .= strtr($submenuTemplate, [
                    '{items}' => $this->createItems($item['items'], true),
                ]);
            }
            $lines[] = Html::tag($tag, $menu, $options);
        }

        return implode("\n", $lines);
    }

    protected function createItem($item, $subMenu)
    {
        if (isset($item['url'])) {
            $template = ArrayHelper::getValue($item, 'template',
                (!$subMenu) ? $this->linkTemplate : $this->linkSubItemTemplate);

            return strtr($template, [
                '{url}' => Html::encode(Url::to($item['url'])),
                '{icon}' => (!$subMenu) ? (isset($item['icon'])) ? $item['icon'] : 'fa fa-file-o' : '',
                '{label}' => $item['label'],
            ]);

        } else if (!isset($item['url']) && isset($item['items'])) {

            $template = ArrayHelper::getValue($item, 'template', $this->linkSubMenuTemplate);

            return strtr($template, [
                '{icon}' => (!$subMenu) ? (isset($item['icon'])) ? $item['icon'] : 'fa fa-file-o' : '',
                '{label}' => $item['label'],
            ]);
        } else {
            $template = ArrayHelper::getValue($item, 'template', $this->categoryTemplate);

            return strtr($template, [
                '{category}' => $item['category'],
            ]);
        }

    }
}