<?php
namespace blankon\widgets;
use Yii;
use yii\grid\ActionColumn;
use yii\helpers\Html;

class BlankonActionColumn extends ActionColumn
{
    public $contentOptions = ['style' => 'width:120px;'];
    public $header = 'Actions';

    protected function initDefaultButtons()
    {
        if (!isset($this->buttons['view'])) {
            $this->buttons['view'] = function ($url, $model, $key) {
                $options = array_merge([
                    'title' => Yii::t('yii', 'View'),
                    'aria-label' => Yii::t('yii', 'View'),
                    'data-pjax' => '0',
                    'class' => 'btn btn-xs rounded btn-success',
                ], $this->buttonOptions);
                return Html::a('<span class="glyphicon glyphicon-eye-open"></span>', $url, $options);
            };
        }
        if (!isset($this->buttons['update'])) {
            $this->buttons['update'] = function ($url, $model, $key) {
                $options = array_merge([
                    'title' => Yii::t('yii', 'Update'),
                    'aria-label' => Yii::t('yii', 'Update'),
                    'data-pjax' => '0',
                    'class' => 'btn btn-xs rounded btn-primary'
                ], $this->buttonOptions);
                return Html::a('<span class="glyphicon glyphicon-pencil btn-primary"></span>', $url, $options);
            };
        }
        if (!isset($this->buttons['delete'])) {
            $this->buttons['delete'] = function ($url, $model, $key) {
                $options = array_merge([
                    'title' => Yii::t('yii', 'Delete'),
                    'aria-label' => Yii::t('yii', 'Delete'),
                    'data-confirm' => Yii::t('yii', 'Are you sure you want to delete this item?'),
                    'data-method' => 'post',
                    'data-pjax' => '0',
                    'class' => 'btn btn-xs rounded btn-danger',
                ], $this->buttonOptions);
                return Html::a('<span class="glyphicon glyphicon-trash btn-danger"></span>', $url, $options);
            };
        }
    }
}