Blankon FullPack Admin Theme Yii 2
============================

Blankon FullPack Admin Theme Project is a set of widgets which give you menu, gridview base on blankon admin template.

DIRECTORY STRUCTURE
-------------------

      assets/             contains assets definition
      widgets/            contains widgets

REQUIREMENTS
------------

The minimum requirement by this project template that your Web server supports PHP 5.4.0.

INSTALLATION
------------

### Install via Composer

You have to add your ssh key to this repo.

Steps: 
     
     composer.json
 
         "repositories": [
            {
                "type": "composer",
                "url": "https://composer.oms.systems"
            }
         ]
     
     
     auth.json

        {
             "http-basic": {"composer.oms.systems": {"username": "oms", "password": "Ap5AJN86bLg93dxX"}}
        }
        
     Add to 'require' name of it
            
        composer require "app-crm/blankon-fullpack-admin-theme" "~1.0"


HOW USE IT
-------------

### BUNDLE ASSET

        use blankon\assets\BlankonAsset;
        BlankonAsset::register($this);

### MENU:

    \blankon\widgets\BlankonMenu::widget([
        'items' => [
            // It's categoty of menu, you have to add only 'categoty' item with name
            ['category' => 'TEST'],
            ['label' => 'Home', 'url' => ['site/index']],
            // If you want to have a submenu, you don't add url to menu item
            ['label' => 'Products', 'items' => [ 
                ['label' => 'New Arrivals', 'url' => 'index.php?r=admin%2Fform%2Felement'],
                ['label' => 'Most Popular', 'url' => ['product/index', 'tag' => 'popular']],
            ]],
            ['label' => 'Login', 'url' => ['site/login'], 'visible' => Yii::$app->user->isGuest],
        ],
    ]);
    
    If you use this menu, put all your contect (without menu) in:
    <section id="page-content">
        <div class="body-content"></div>
        <footer></footer>
    </section> 
    
### GRIDVIEW:

    \blankon\widgets\BlankonGridView::widget([
         'dataProvider' => $dataProvider->search(),
         'columns' => [
             'id',
             'name',
             'position',
             'rating',
             'team',
             [
                 'class' => \blankon\widgets\BlankovActionColumn::className(),
                 'contentOptions' => ['style' => 'width:140px;'],
                 'header' => 'Actions',
                 'template' => '{view} {update} {delete}', // basic buttons
                 'buttons' => [],
             ],
         ]
    ])
